#ifndef __C4DBASEKEY_H
#define __C4DBASEKEY_H

#include "c4d_baselist.h"
#include "operatingsystem.h"
#include "ge_vector.h"

class BaseObject;
class BaseDocument;
class BaseTrack;
class BaseSequence;

class BaseKey : public BaseList2D
{
	private:
		BaseKey(void);
	public:
		BaseSequence  *GetSequence(void) { return (BaseSequence*)AtCall(GetMain)(); }
		BaseTrack			*GetTrack   (void);
		BaseList2D    *GetObject  (void);

		void					SetTime(const BaseTime &time);
		BaseTime			GetTime(void);
		Bool					FillKey(void) { return C4DOS.Bk->FillKey(this); }

		BaseKey *GetNext(void) { return (BaseKey*)AtCall(GetNext)(); }
		BaseKey *GetPred(void) { return (BaseKey*)AtCall(GetPred)(); }

		static BaseKey *Alloc(LONG type);
		static void Free(BaseKey *&key);
};

class PluginKey : public BaseKey
{
	public:
		static PluginKey *Alloc(LONG type);
		static void Free(PluginKey *&key);
};

class PLAKey : public BaseKey
{
	private:
		PLAKey(void);
	public:
		VariableTag *GetPointTag(void);
		VariableTag *GetHermiteTag(void);

		static PLAKey *Alloc();
		static void Free(PLAKey *&bl);
};

struct AnimValue
{
	Real value,value_left,value_right;
	Real time_left,time_right;
	Real str_left,str_right;
	LONG inter_left,inter_right;
	Bool link_leftright;

private:
	AnimValue(void) { }
};

AnimValue *GetKeyValue(BaseKey *key);

#endif
